//Scripted by Jumpnjahosofat
//This file is part of the Urshaabi Gauntlet System
//I do not take complete credit for all of the files.  Many are modified RunUO scripts.
//This system is intended for drop in purposes so that it's easy for everyone to enjoy it.
//If you encounter problems, please leave me a message on the forum or my email - uo_cecil@yahoo.com
//Enjoy!!

using System;
using Server;
using Server.Items;
using System.Collections;

namespace Server.Mobiles
{
	//[CorpseName( "the corpse of Bonesoul" )]
	public class Bonesoul : BaseCreature
	{
		public override WeaponAbility GetWeaponAbility()
		{
			return WeaponAbility.WhirlwindAttack;
		}

		[Constructable]
		public Bonesoul () : base(AIType.AI_Mage, FightMode.Closest, 10, 1, 0.2, 0.4)
		{
			Name = "Bonesoul";
			Title = "The Gauntlet Guardian";
			Body = 104;
			BaseSoundID = 0x488;

			SetStr(800);
			SetDex(68, 200);
			SetInt(488, 620);

			SetHits(6000);

			SetDamage(40, 50);

			SetDamageType(ResistanceType.Physical, 75);
			SetDamageType(ResistanceType.Fire, 25);

			SetResistance(ResistanceType.Physical, 75, 80);
			SetResistance(ResistanceType.Fire, 40, 60);
			SetResistance(ResistanceType.Cold, 40, 60);
			SetResistance(ResistanceType.Poison, 70, 80);
			SetResistance(ResistanceType.Energy, 40, 60);

			SetSkill(SkillName.EvalInt, 80.1, 100.0);
			SetSkill(SkillName.Magery, 80.1, 100.0);
			SetSkill(SkillName.MagicResist, 100.3, 130.0);
			SetSkill(SkillName.Tactics, 97.6, 100.0);
			SetSkill(SkillName.Wrestling, 97.6, 100.0);

			Fame = 22500;
			Karma = -22500;

			VirtualArmor = 55;
		}

		public override void GenerateLoot()
		{
			AddLoot(LootPack.UltraRich, 3);
		}

		public override bool OnBeforeDeath()
		{
			StarRoomGate gate = new StarRoomGate(true);
			gate.Name = "Gauntlet of Horrors Level 4";
			gate.Target = new Point3D(5288, 1185, 0);
			gate.TargetMap = Map.Trammel;
			gate.Hue = 34;
			gate.MoveToWorld(new Point3D(5306, 1173, 0), this.Map);

			return base.OnBeforeDeath();
		}

		public override bool ReacquireOnMovement { get { return true; } }
		public override bool HasBreath { get { return true; } } // fire breath enabled
		public override int BreathFireDamage { get { return 0; } }
		public override int BreathColdDamage { get { return 100; } }
		public override int BreathEffectHue { get { return 0x480; } }
		public override double BonusPetDamageScalar { get { return (Core.SE)? 3.0 : 1.0; } }
		public override bool IsNotScaredOfDeath { get { return true; } } //neutika pri malem poctu hp

		public override bool AutoDispel { get { return true; } }
		public override Poison PoisonImmune { get { return Poison.Lethal; } }
		public override bool BleedImmune { get { return true; } }
		public override int Meat { get { return 19; } } // where's it hiding these? :)
		public override int Hides { get { return 20; } }
		public override HideType HideType { get { return HideType.Barbed; } }

		public override void OnDamage(int amount, Mobile from, bool willKill, int typ)
		{
			base.OnDamage(amount, from, willKill, typ);

			//          // eats pet or summons
			if (from is BaseCreature)
			{
				BaseCreature creature = (BaseCreature) from;

				if (creature.Controlled || creature.Summoned)
				{
					creature.Kill();

					Effects.PlaySound(Location, Map, 0x574);
				}
			}

			// teleports player near
			if (from is PlayerMobile && !InRange(from.Location, 1) && Utility.RandomDouble() < 0.1)
			{
				Combatant = from;

				from.MoveToWorld(Location, Map);
				from.FixedParticles(0x376A, 9, 32, 0x13AF, EffectLayer.Waist);
				from.PlaySound(0x1FE);
			}
		}

		public override void OnDamagedBySpell(Mobile attacker)
		{
			base.OnDamagedBySpell(attacker);

			ScaleResistances();
			DoCounter(attacker);
		}

		public override void OnGotMeleeAttack(Mobile attacker)
		{
			base.OnGotMeleeAttack(attacker);

			ScaleResistances();
			DoCounter(attacker);
		}

		private void ScaleResistances()
		{
			double hitsLost = (HitsMax - Hits) / (double)HitsMax;

			SetResistance(ResistanceType.Physical,	30 + (int)(hitsLost * (95 - 30)));
			SetResistance(ResistanceType.Fire,		60 + (int)(hitsLost * (95 - 60)));
			SetResistance(ResistanceType.Cold,		60 + (int)(hitsLost * (95 - 60)));
			SetResistance(ResistanceType.Poison,	90 + (int)(hitsLost * (95 - 90)));
			SetResistance(ResistanceType.Energy,	50 + (int)(hitsLost * (95 - 50)));
		}

		private void DoCounter(Mobile attacker)
		{
			if (this.Map == null || (attacker is BaseCreature && ((BaseCreature)attacker).BardProvoked))
				return;

			if (0.2 > Utility.RandomDouble())
			{
				/* Counterattack with Hit Poison Area
				 * 20-25 damage, unresistable
				 * Lethal poison, 100% of the time
				 * Particle effect: Type: "2" From: "0x4061A107" To: "0x0" ItemId: "0x36BD" ItemIdName: "explosion" FromLocation: "(296 615, 17)" ToLocation: "(296 615, 17)" Speed: "1" Duration: "10" FixedDirection: "True" Explode: "False" Hue: "0xA6" RenderMode: "0x0" Effect: "0x1F78" ExplodeEffect: "0x1" ExplodeSound: "0x0" Serial: "0x4061A107" Layer: "255" Unknown: "0x0"
				 * Doesn't work on provoked monsters
				 */

				Mobile target = null;

				if (attacker is BaseCreature)
				{
					Mobile m = ((BaseCreature)attacker).GetMaster();

					if (m != null)
						target = m;
				}

				if (target == null || !target.InRange(this, 25))
					target = attacker;

				this.Animate(10, 4, 1, true, false, 0);

				ArrayList targets = new ArrayList();

				foreach (Mobile m in target.GetMobilesInRange(8))
				{
					if (m == this || !CanBeHarmful(m))
						continue;

					if (m is BaseCreature && (((BaseCreature)m).Controlled || ((BaseCreature)m).Summoned || ((BaseCreature)m).Team != this.Team))
						targets.Add(m);
					else if (m.Player)
						targets.Add(m);
				}

				for (int i = 0; i < targets.Count; ++i)
				{
					Mobile m = (Mobile)targets[i];

					DoHarmful(m);

					AOS.Damage(m, this, Utility.RandomMinMax(10, 15), true, 0, 0, 0, 100, 0);

					m.FixedParticles(0x36BD, 1, 10, 0x1F78, 0xA6, 0, (EffectLayer)255);
					m.ApplyPoison(this, Poison.Lethal);
				}
			}
		}

		public Bonesoul(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);
			writer.Write((int) 0);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);
			int version = reader.ReadInt();
		}
	}
}